# Claude 4炸裂发布！凭什么敢称宇宙最强编程 AI？

5 月 23 日，Claude 官方宣布推出下一代 Claude 模型：Claude Sonnet 4 和 Claude Opus 4，直接 **在全世界的 AI 圈掀起了新的风暴**！

据官方称，Claude Opus 4 是 **世界上最好的编程模型**，在复杂、长期运行的任务和智能体工作流程中具有持续性能，能够连续工作数小时。据说有家日本公司使用它重构一套复杂的开源项目代码，结果它自主运行了 7 个小时，一直源源不断地生成代码。

好家伙，这持久性，都快能平替我们标准的 8 小时工作制了。以后我上班就打开 AI 工具让它自己生成代码，只要下班前检查一下，就可以愉快下班了，真是充实且摸鱼的一天啊！

![](https://pic.yupi.icu/1/1748049116801-cdfba9b0-ddec-4f01-b502-20490c50bc26.png)

Claude 4 一出现，直接为编程、高级推理和 AI 智能体设立了新标准，达到 SOTA！

SOTA（State of the Art）是一个典型的互联网黑话，常用来描述在某一特定领域内当前最佳的技术。

如图，Claude 4 模型在 SWE-bench Verified 上领先，这是一个评估真实软件工程任务性能的基准。

![](https://pic.yupi.icu/1/1747986906326-011c53e7-a1be-4a5f-a907-c570dfa53da5-20250524120720364.png)

Claude Sonnet 4 模型则是对 Claude Sonnet 3.7 的重大升级，在编程和推理方面表现更优异。虽然在大多数领域不及 Opus 4，但它也吊打了其他大模型，提供了能力和实用性的最佳组合，而且最关键的是 **对免费用户开放**。

![](https://pic.yupi.icu/1/1747986915100-240318d1-19ce-4c7e-b6c2-f4e9e1e4886c-20250524120720453.png)

作为一个一直依赖 AI 编程的中毒患者，3.7 已经让我很爽了，4 这个大版本不得起飞了啊？！想想当年的 GPT-3 和 GPT-4 的差距，直接把我的期待值拉满了，下面我带大家一起来试试效果。

> 叠甲声明，鱼皮并不是专业的测试，更多的只是作为一个用户，分享我自己真实的使用体验。



## Claude 实战

Claude 的使用非常简单，直接进入官网（[claude.ai](https://claude.ai/)）就可以免费使用 Claude Sonnet 4 模型了：

![](https://pic.yupi.icu/1/1748054205184-19a24053-dd9a-4128-a072-0d3e031c2646.png)

如果你想用 Claude 来编程、生成网站，建议还是选择专业的 AI 开发工具 Cursor，也已经第一时间集成了 Claude 4 系列模型。

![](https://pic.yupi.icu/1/1748054309771-fc7782f4-3c98-45e0-b276-b314b638a163.png)

下面鱼皮将使用 Cursor 带大家开发 3 个不同类型的网站项目：

- 工具类网站：文件格式转换工具
- 休闲娱乐类：连连看小游戏
- 企业实用类：科技公司官网

有些博主只是单纯测试使用 claude 4 来生成网站的效果，其实并不能体现出大模型进化了多少。而鱼皮针对每个项目将分别采用 claude-3.7-sonnet、claude-4-sonnet 和 claude-4-opus，利用相同的 Prompt 提示词进行生成，从而对比效果。



### 1、文件格式转换工具

首先准备一段 Prompt，这里我们不使用过于专业的 Prompt，给 AI 足够的发散空间和创作自由，让他们自己来完成任务，更容易看出差距。

```plain
请生成一个《文件格式转换工具》网站，实现常见文件格式转换功能：
- 支持图片、文档、音频等格式的转换
- 上传文件后选择目标格式，点击转换按钮
- 展示转换进度，完成后可以让用户下载

设计要求：
- 现代简洁风格，主色调使用蓝色
- 响应式布局，适配手机和桌面
```

在 Cursor 中选择对应的大模型、以及 Agent 智能体模式，然后执行 Prompt：

![](https://pic.yupi.icu/1/1748054782941-36a20b14-52cb-49c5-b84f-f25f4fa46fcb.png)

等待一段时间后，就可以看到生成的效果了。比较坑的一点是，目前 Claude 4 Opus 模型过于火爆，一直提示说使用的人太多。。。本来我昨天就想发教程了，但就是卡在这一步，直到今天早上 8 点多才能正常使用。

![](https://pic.yupi.icu/1/1748054838846-ce6a7ae0-ebf5-47bb-a15b-c258412abe32.png)

我们将分别从生成 **代码的结构、网站的界面、网站的功能** 这 3 个角度来对比大模型的代码生成效果。

#### 代码结构对比

claude-3.7-sonnet 使用了 Next.js 前端框架技术来生成代码，生成了一个较为复杂的项目；而 claude-4-sonnet 和 claude-4-opus 直接使用最基础的前端三件套（HTML + CSS + JavaScript）完成了项目。

![](https://pic.yupi.icu/1/1748055308007-48020e0f-3055-40b8-a9f4-2090cf8ec92c.png)

单看项目结构我们很难评判谁做的更好，因为有时候高端的功能往往只需要简单的技术实现，less is more。



#### 网站界面对比

每个模型生成的网站都很简洁，效果还不错。但我会更喜欢 claude-4-sonnet，因为它给出了更多的引导信息，比如支持的转换格式等。

![](https://pic.yupi.icu/1/1748055697162-ea03506c-b109-475d-b15a-d9cc2a8f70d2.png)

选择一个文件后，claude-4-sonnet 和 claude-4-opus 生成的网站出现了动态交互效果，显示出了待转换的文件，并且提示用户要选择目标格式。而且我注意到一些小细节，比如文件大小的展示更精确了、选择格式的 UI 也更好看。

![](https://pic.yupi.icu/1/1748055843229-9f4d4bb8-1395-4d8f-9ee8-77af572b6939.png)

转换成功后，显然 claude-4-sonnet 和 claude-4-opus 的成功提示和下载按钮更明显，高下立判！

![](https://pic.yupi.icu/1/1748056009117-e40e7bf9-bea8-41a3-aaa4-3d52c67d842b.png)

#### 网站功能对比

比较遗憾的是，所有模型生成的网站都只是有个“壳”，虽然输出了 “文件转换成功”，但实际上只是改了文件的后缀名而已，并没有真的转换格式。看下代码就知道了：

![](https://pic.yupi.icu/1/1748056469598-718d301b-da62-4fcc-b633-87b8b63f4534.png)

有意思的是，如果我上传一个不支持的格式，claude-3.7-sonnet 会给出弱弱的警告；claude-4-sonnet 会给出更强力的弹窗警告；而 claude-4-opus 可以说是死鸭子嘴硬，我可以继续选择转换格式，它也装作能处理的样子，还给我提示转换成功。

![](https://pic.yupi.icu/1/1748056242227-9aa2dab7-41b1-437f-88b7-ccb74ae0bf99.png)

毕竟只是改个后缀而已，这么玩当然什么格式都能转换了！你们说 claude-4-opus 这样算是更智能么？



### 2. 休闲连连看游戏

首先准备一段 Prompt，交给 Cursor 去执行：

```plain
请创建一个《连连看》游戏网站，实现功能：
- 玩法遵循经典的连连看游戏玩法，相同图标可消除
- 计时系统和简单得分机制
- 提供一些道具，增加游戏趣味性

设计要求：
- 活泼可爱风格
- 响应式设计，适配不同设备
- 添加图标消除动画和道具特效
```



#### 代码结构对比

跟生成文件格式转换工具类似，claude-3.7-sonnet 使用了 React 前端框架技术来生成代码，生成了一个较为复杂的项目；而 claude-4-sonnet 和 claude-4-opus 直接使用最基础的前端三件套（HTML + CSS + JavaScript）完成了项目。

![](https://pic.yupi.icu/1/1748056960115-744a9731-0049-41c5-9e6b-616c6aca6c00.png)

看到这里，我开始相信了：高端的功能往往只需要简单的技术实现，less is more！



#### 网站界面对比

每个模型都理解了任务，生成出了经典连连看游戏的页面，都显示了得分、时间和道具。但是界面美观度高下立判啊！claude-3.7-sonnet 生成的游戏带着一股土味儿，而 claude-4-sonnet 和 claude-4-opus 界面都很软萌 Q 弹，风格也比较接近，不愧是同系列的模型。

![](https://pic.yupi.icu/1/1748057128402-f6b13ee2-4092-453c-bffe-e82b34e50f4e.png)



#### 网站功能对比

所有模型生成的游戏都是能正常操作的，可以消除图案相同的方块，也可以使用提示、洗牌、停止计时、炸弹等道具。但是 AI 对连连看游戏的理解好像有点问题，比如下面这种情况，我记得是能消除的吧？但是生成的游戏无法顺利消除。。。

![](https://pic.yupi.icu/1/1748057414393-615b510b-8aec-436c-ae84-cc1d31f2b341.png)

所以功能上算是 3 个大模型打平了。但说真的，能通过一个 Prompt 提示词、花几分钟就生成出这种效果，已经很强了。这哪怕让一个精通前端的大佬来写，最少也得花几个小时吧？



### 3. 科技公司官网

我们再来一个企业开发的需求，帮鱼皮自己的公司做个官方网站。准备一段 Prompt，交给 Cursor 去执行：

```plain
请为《鱼鸢网络》公司创建一个简洁的官方网站，展示公司信息：
- 鱼鸢网络成立于2023年，是一家专注于编程教育、创新产品研发、科技自媒体等领域的新兴互联网企业。
- 旗下自研产品编程导航、面试鸭、老鱼简历、代码小抄、剪切助手、算法导航等为用户的工作和生活提供了更高效、易用的技术工具。专业编程学习交流网站编程导航为广大编程爱好者及从业人员提供了编程学习、项目实战、求职交流的全链路服务。
- 我们致力于通过科技创新，提升用户在学习、工作、生活中获取信息的效率，让技术更好地服务于每一个人。

设计要求：
- 专业商务风格，简洁大气
- 响应式布局，移动端友好
```

这个需求其实比前面 2 个简单多了，AI 也很快完成了任务。



#### 代码结构对比

这次的生成结果可就有意思了，claude-3.7-sonnet 和 claude-4-sonnet 直接使用最基础的前端三件套（HTML + CSS + JavaScript）完成了项目，而 claude-4-opus 却使用了 React 前端框架技术来生成代码，并且把一个简单的页面拆分成了很多个小组件。

![](https://pic.yupi.icu/1/1748057919666-0a068e65-a264-481a-bb53-f8c8027733cc.png)

出现这种情况也很正常，毕竟 AI 生成是具有一定随机性的，我们还是来看看效果如何。



#### 网站界面对比

所有大模型生成的界面都是支持响应式的，从移动端小屏来看没有明显的差别：

![](https://pic.yupi.icu/1/1748058152472-9afdd0b3-58f1-458c-a3f0-e6d7a0faefda.png)

但是 PC 端大屏的区别就很明显了，从 “关于我们” 板块就能看出，claude-4-sonnet 和 claude-4-opus 生成的页面明显具有更多的细节，让网站内容更充实。这波又是新模型的胜利~

![](https://pic.yupi.icu/1/1748058338558-466e055c-d08d-4b0d-bb98-e5107a30184e.png)



## 总结

通过上面三个例子，我个人感觉 claude-4-sonnet 和 claude-4-opus 从生成效果上 **几乎是完胜** claude-3.7-sonnet 的。而且新版本的模型更聪明，不仅默认会选择更简单的技术来实现需求，而且还补充了更多的内容细节、更美观的样式和更自然的交互。

可惜现在用新模型的人比较多，生成代码时会遇到连接失败、或者让我等等的情况。建议大家早上 8 点多的时候使用，亲测这个时候比较快~

对了，还得提醒一下，目前使用 claude 4 系列模型是按照 token 计费的，Claude 官方给出的价格是 Opus 4 每百万 token 15/75美元（输入/输出），Sonnet 4 为 3/15 美元。而在 Cursor 中使用 Opus 4 是按 token 计费，使用 Sonnet 4（非 MAX 版本）是按照请求数计费，目前还有 75 折，一个请求大概是 0.04 美元。

![](https://pic.yupi.icu/1/1748059004335-70d84599-d7c6-4b3c-b682-7fa32f15a05c.png)

帮大家粗略估算一下价格，还是有点小贵的：

| 模型/平台       | 计费方式        | 10000 字中文         | 价格       |
| --------------- | --------------- | -------------------- | ---------- |
| Claude Opus 4   | 输出 token 计费 | 1.5 美元             | 约 11 元   |
| Claude Sonnet 4 | 输出 token 计费 | 0.3 美元             | 约 2.2 元  |
| Cursor Sonnet 4 | 请求数计费      | 0.2 美元（5 次请求） | 约 1.46 元 |

相信大家也感受到 AI 的恐怖了，即使我只给出了简单的提示词，大模型也能准确理解我的需求并快速生成代码。而这个能力还会持续进化。。。**如果我们现在还不会使用 AI 生成代码，可能很快真的要被淘汰了。**

欢迎加入我们的 AI 交流群，获得更多最新资讯、AI 玩法等内容～

![AI交流群](https://pic.yupi.icu/yuyi/640-20250530155801513.png)